package gov.va.genisis2.controller;

import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.bo.BusinessService;
import gov.va.genisis2.common.enums.CommonEnum;
import gov.va.genisis2.dao.impl.RequestDao;
import gov.va.genisis2.dto.CommentHistoryDTO;
import gov.va.genisis2.dto.StudyApprovalDTO;
import gov.va.genisis2.exceptions.ErrorResponse;
import gov.va.genisis2.exceptions.Genisis2RestException;
import gov.va.genisis2.exceptions.GenisisException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.service.impl.RequestService;
import gov.va.genisis2.util.Helper;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2.vo.CopyTableSource;

/**
 * The Class Genisis2ControllerTest.
 *
 * @author1 Janet Lopez
 * @author Getaneh Kassahun
 * 
 *          The Class Genisis2ControllerTest.
 * 
 *          Description: In this Genisis2ControllerTest Class which extends the
 *          abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class Genisis2ControllerTest extends AbstractMockMvcTests {

	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(Genisis2ControllerTest.class);
	
	private Genisis2Controller genisis2Controller;
	
	private BusinessService businessService_SF_NULL;
	
	private RequestService requestService_SF_NULL;

	private RequestDao requestDao_SF_Null;

	/**
	 * This method is used to testGenisis2ControllerAllRequests.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testAllRequests() throws Exception {
		
		LOGGER.info("**********Junit Get all requests**********");

		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getAllRequests()).thenReturn(wrapper);
		getMockMvc().perform(
				get("/services/requests").contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON))
				.andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestByID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestByID() throws Exception {
		
		LOGGER.info("**********Junit Get Request by ID**********");
		int id = 1;
		Long idL = 1L;
		String role = "Admin";
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getRequestTrackingByID(id, role)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{id}", idL.toString()).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerCopyTableDomains.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testCopyTableDomains() throws Exception {
		
		LOGGER.info("**********Junit Get Copy Table Domains**********");

		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getCopyTableDomainDetails()).thenReturn(wrapper);
		getMockMvc().perform(get("/services/copytable/domains").contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetDataSources.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetDataSources() throws Exception {
		
		LOGGER.info("**********Junit Get Data Sources**********");

		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getRequestDataSources()).thenReturn(wrapper);
		getMockMvc().perform(
				get("/services/datasources").contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON))
				.andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetUserDetailsByEmail.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetUserDetailsByEmail() throws Exception {
		
		LOGGER.info("**********Junit Get Login Details By Email**********");
		String email = "emailid@gmail.com";
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getUserDetailsByEmail(email)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/users/{email}/email", email.toString())
				.contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetUsersDetailsById.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetUsersDetailsById() throws Exception {
		
		LOGGER.info("**********Junit Get Login Details By Id**********");
		int id = 1;
		getMockMvc().perform(get("/services/users/{id}", id).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetUserRole.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetUserRole() throws Exception {
		
		LOGGER.info("**********Junit Get User Role**********");
		int id = 1;
		getMockMvc().perform(get("/services/users/role/{uid}", id).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestsByUser.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestsByUser() throws Exception {
		
		LOGGER.info("**********Junit Get Requests By User**********");
		String uid = "testresearcher";
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getRequestsByUID(uid)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{uid}/createdBy", uid).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestByDataManager.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestByDataManager() throws Exception {
		
		LOGGER.info("**********Junit Get Requests By Data Manager**********");
		String id = "tesdatatmanager";
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getRequestsByDataManagers(id)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{id}/dataManager", id).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}
	
	/**
	 * This method is used to testGenisis2ControllerGetRequestsDataSourceManagers.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestsDataSourceManagers() throws Exception {
		
		LOGGER.info("**********Junit Get Requests for Data Source Managers**********");
		String id = "tesdatasourcemanagers";
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getRequestsDataSourceManagers(id)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{id}/dataSourceManager", id).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to
	 * testGenisis2ControllerGetRequestStudyApprovalsByIDUID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestStudyApprovalsByIDUID() throws Exception {
		
		LOGGER.info("**********Junit Get Study Approvals by UID**********");
		int id = 1;
		Long idL = 1L;
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getAllRequestsByStudyApproval(id)).thenReturn(wrapper);
		getMockMvc()
				.perform(get("/services/requests/{studyApprovalId}/studyApproval", idL.toString())
						.contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON))
				.andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetAllStudyApproval.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetAllStudyApproval() throws Exception {
		
		// set up studyApproval model in setup using hibernate template
		LOGGER.info("**********Junit Get All Request By Study Approval**********");

		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getStudyApprovals()).thenReturn(wrapper);
		getMockMvc().perform(get("/services/studyApprovals").contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetAllStudyApprovalsByID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetAllStudyApprovalsByID() throws Exception {
		
		LOGGER.info("**********Junit Get All Study Approvals**********");
		int id = 1;
		Long idL = 1L;
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getStudyApprovalsByID(id)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/studyApprovals/{id}", idL.toString())
				.contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetStudyApprovalsByIDUID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetStudyApprovalsByIDUID() throws Exception {
		
		LOGGER.info("**********Junit Get Study Approvals by UID**********");
		String uid = "testmanager";
		String user = "testmanager";
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getStudyApprovalsByUID(uid)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/studyApprovals/{uid}/{user}", uid, user)
				.contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestTrackingByID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestTrackingByID() throws Exception {
		
		LOGGER.info("**********Junit Get Request Tracking by ID**********");
		int id = 1;
		Long idL = 1L;
		String userRole = "Admin";
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getRequestTrackingByID(id, userRole)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{id}/{userRole}/log", idL.toString(), userRole).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestTypes.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestTypes() throws Exception {
		
		LOGGER.info("**********Junit Get Request Types**********");
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getRequestTypes()).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requestTypes").contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestByStatus.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestByStatus() throws Exception {
		
		LOGGER.info("**********Junit Get All Request By Status**********");
		String status1 = CommonEnum.NO_RECORD_FOUND.getText();
		getMockMvc().perform(get("/services/requests/{status}/status", status1).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}
	
	/**
	 * This method is used to testGetUserByUsername.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetUserByUsername() throws Exception {
		
		LOGGER.info("**********Junit test Get UserByUsername**********");
		String userName = "VhAiSAFRANciss";
		ResponseWrapper wrapper = new ResponseWrapper();
		
		when(getMockBusinessService().getUserDetailsByUsername(userName)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/users/username/{username}", userName).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}
	
	/**
	 * This method is used to test getUserCountsAndLdapLastRefresh.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetUserCountsAndLdapLastRefresh() throws Exception {
		
		LOGGER.info("**********Junit test getUserCountsAndLdapLastRefresh**********");
		ResponseWrapper wrapper = new ResponseWrapper();
		
		when(getMockBusinessService().getUserCountsAndLdapLastRefresh()).thenReturn(wrapper);
		getMockMvc().perform(get("/services/users/lastRefreshed").contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}
	
	/**
	 * This method is used to test refreshUserData.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testRefreshUserData() throws Exception {
		
		LOGGER.info("**********Junit test refreshUserData**********");
		String username = "VhAiSAFRANciss";
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().refreshUserData(username)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/users/ldapRefresh/{username}", username).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}
	
	/**
	 * This method is used to test refreshUserData.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestStatusCounts() throws Exception {
		
		LOGGER.info("**********Junit test getRequestStatusCounts**********");
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getRequestStatusCounts()).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/status/count").contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}
	
	/**
	 * Test getRequestStatusCounts.
	 * @throws GenisisException 
	 */
	/*@Test(expected = Exception.class)
	public void testGetRequestStatusCounts_null() throws GenisisException {

		setSessionFactory_Null();
		genisis2Controller.getRequestStatusCounts();
	}*/

	/**
	 * This method is used to testGenisis2ControllerPutStudyApproval_1.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutStudyApproval_1() throws Exception {
		LOGGER.info("**********Junit put StudyApproval**********");
		// id is > 0
		int id = 3;

		StudyApprovalDTO studyApproval = Helper.getStudyApprovalDTO();

		ResponseEntity<ResponseWrapper> ent = getGenisis2Controller().updateStudyApproval(id, studyApproval);

		Assert.assertNotNull(ent.getStatusCode());
		LOGGER.info("**********End of Junit put StudyApproval**********");
	}

	/**
	 * This method is used to testGenisis2ControllerPutStudyApproval_2.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutStudyApproval_2() throws Exception {
		LOGGER.info("**********Junit put StudyApproval**********");
		// id is 0
		int id = 0;

		StudyApprovalDTO studyApproval = Helper.getStudyApprovalDTO();

		ResponseEntity<ResponseWrapper> ent = getGenisis2Controller().updateStudyApproval(id, studyApproval);

		Assert.assertNotNull(ent.getStatusCode());

		LOGGER.info("********** end test for Junit put StudyApproval  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerCreateComment.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void createComment() throws Exception {
		LOGGER.info("**********Junit POST TEST for Create Comment  **********  ");
		CommentHistoryDTO commentHistory = new CommentHistoryDTO();
		commentHistory.setRequestId(1);
		commentHistory.setComments("testing");
		commentHistory.setStatus("Submitted");
		commentHistory.setCreatedBy("datamanager1");
		ResponseEntity<ResponseWrapper> ent = getGenisis2Controller().createCommentHistory(commentHistory);

		Assert.assertNotNull(ent.getStatusCode());

		LOGGER.info("**********End of Junit POST TEST for Create Comment **********  " + ent.getStatusCode());
	}

	/**
	 * This method is used to
	 * testGenisis2ControllerPerformTableCopyTransferTest.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void performTableCopyTransferTest() throws Exception {
		LOGGER.info("**********Junit POST TEST for perform Table Copy Transfer  **********  ");
		int id = 1;
		CopyTableSource copyTableSource1 = new CopyTableSource();
		copyTableSource1.setTableName("Table1");

		ResponseEntity<ResponseWrapper> ent = getGenisis2Controller().performTableCopyTransfer(id, copyTableSource1);

		Assert.assertNotNull(ent.getStatusCode());

		LOGGER.info("**********End of Junit POST TEST for Table Copy Transfer **********  " + ent.getStatusCode());

	}

	/**
	 * This method is used to testGenisis2ControllerCreateStudyApproval.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void createStudyApproval() throws Exception {
		LOGGER.info("**********Junit POST TEST for create Study Approval  **********  ");

		StudyApprovalDTO studyApprovalDto = Helper.getStudyApprovalDTO();
		ResponseEntity<ResponseWrapper> ent = getGenisis2Controller().createStudyApproval(studyApprovalDto);

		Assert.assertNotNull(ent.getStatusCode());

		LOGGER.info("********** end of Junit POST TEST for Study Approval  **********  " + ent.getStatusCode());

	}

	/**
	 * This method is used to TestException.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void TestException() throws Exception {
		LOGGER.info("**********Junit POST TEST for Exception  **********  ");

		Genisis2RestException ex = new Genisis2RestException("errorMessageTestOne");

		ResponseEntity<ErrorResponse> ent = getGenisis2Controller().exceptionHandler(ex);
		Assert.assertNotNull(ent.getStatusCode());

		LOGGER.info("********** end of Junit POST TEST for Exception  **********  " + ent.getStatusCode());

	}

	/**
	 * This method is used to TestGetBusiness.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void TestGetBusiness() throws Exception {
		LOGGER.info("**********Junit for bo*********");

		BusinessService bo = getGenisis2Controller().getBusinessService();
		Assert.assertNotNull(bo);

		LOGGER.info("********** end of Junit for bo**********");

	}
	
	private void setSessionFactory_Null() {

		requestService_SF_NULL = new RequestService();
		businessService_SF_NULL = new BusinessService();
		genisis2Controller = new Genisis2Controller();
		requestDao_SF_Null = new RequestDao();
		requestDao_SF_Null.setSessionFactory(null);
		requestService_SF_NULL.setRequestDao(requestDao_SF_Null);
		businessService_SF_NULL.setRequestService(requestService_SF_NULL);
		genisis2Controller.setBusinessService(businessService_SF_NULL);

	}

}
